(() => {
    'use strict';

    // 特徴指定用の定数
    Game_BattlerBase.TRAIT_ATK_PLUS             = 1001; // 攻撃力プラス
    Game_BattlerBase.TRAIT_ATK_RATE             = 1002; // 攻撃力アップ
    Game_BattlerBase.TRAIT_HP_PLUS              = 1003; // HPプラス
    Game_BattlerBase.TRAIT_HP_RATE              = 1004; // HPアップ
    Game_BattlerBase.TRAIT_HIT_COUNT_PLUS       = 1005; // ヒット数
    Game_BattlerBase.TRAIT_MULTI_ATTACK         = 1006; // 連続攻撃
    Game_BattlerBase.TRAIT_RARITY_UP            = 1007; // レアリティアップ
    Game_BattlerBase.TRAIT_LAST_STAND           = 1008; // 背水
    Game_BattlerBase.TRAIT_VIGOR                = 1009; // 旺盛
    Game_BattlerBase.TRAIT_UNYIELDING           = 1010; // 不屈
    Game_BattlerBase.TRAIT_FORTITUDE            = 1011; // 盤石
    Game_BattlerBase.TRAIT_CRITICAL_PLUS        = 1012; // 会心プラス
    Game_BattlerBase.TRAIT_SUPER_CRITICAL       = 1013; // 超会心
    Game_BattlerBase.TRAIT_DAMAGE_CAP_BREAK     = 1014; // ダメージ上限突破
    Game_BattlerBase.TRAIT_COUNTER              = 1015; // カウンター
    Game_BattlerBase.TRAIT_HP_REGEN             = 1016; // HP再生
    Game_BattlerBase.TRAIT_HP_ATK_PLUS          = 1017; // HP攻撃プラス
    Game_BattlerBase.TRAIT_HP_ATK_RATE          = 1018; // HP攻撃アップ
    Game_BattlerBase.TRAIT_ADRENALINE           = 1019; // 底力
    Game_BattlerBase.TRAIT_FULL_POWER           = 1020; // 万全
    Game_BattlerBase.TRAIT_FATAL_BLOW           = 1021; // 致命必殺

    // 攻撃力の加算値の合計を取得
    Game_BattlerBase.prototype.traitsAtkPlus = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_ATK_PLUS).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_HP_ATK_PLUS).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

     // 攻撃力の乗算値の合計を取得
    Game_BattlerBase.prototype.traitsAtkRate = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_ATK_RATE).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_HP_ATK_RATE).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

    // HPの加算値の合計を取得
    Game_BattlerBase.prototype.traitsHpPlus = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_HP_PLUS).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_HP_ATK_PLUS).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

    // HPの乗算値の合計を取得
    Game_BattlerBase.prototype.traitsHpRate = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_HP_RATE).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_HP_ATK_RATE).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

    // ヒット数の合計を取得
    Game_BattlerBase.prototype.traitsHitCountPlus = function() {
        return this.traits(Game_BattlerBase.TRAIT_HIT_COUNT_PLUS).reduce((r, trait) => r + trait.value, 0);
    };

    // 連続攻撃の合計を取得
    Game_BattlerBase.prototype.traitsMultiAttack = function() {
        return this.traits(Game_BattlerBase.TRAIT_MULTI_ATTACK).reduce((r, trait) => r + trait.value, 0);
    };

    // レアリティアップの合計を取得
    Game_BattlerBase.prototype.traitsRarityUp = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_RARITY_UP).reduce((r, trait) => r + trait.value, 0);
        return Math.min(a, 200);
    };

    // 背水の合計を取得
    Game_BattlerBase.prototype.traitsLastStand = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_LAST_STAND).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_ADRENALINE).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

    // 旺盛の合計を取得
    Game_BattlerBase.prototype.traitsVigor = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_VIGOR).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_FULL_POWER).reduce((r, trait) => r + trait.value, 0);
        return a + b;
    };

    // 不屈の合計を取得
    Game_BattlerBase.prototype.traitsUnyielding = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_UNYIELDING).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_ADRENALINE).reduce((r, trait) => r + trait.value, 0);
        return Math.min(a + b, 50);
    };

    // 盤石の合計を取得
    Game_BattlerBase.prototype.traitsFortitude = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_FORTITUDE).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_FULL_POWER).reduce((r, trait) => r + trait.value, 0);
        return Math.min(a + b, 50);
    };

    // 会心プラスの合計を取得
    Game_BattlerBase.prototype.traitsCriticalPlus = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_CRITICAL_PLUS).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_FATAL_BLOW).reduce((r, trait) => r + trait.value, 0);
        return Math.min(a + b, 100);
    };

    // 超会心の合計を取得
    Game_BattlerBase.prototype.traitsSuperCritical = function() {
        const a = this.traits(Game_BattlerBase.TRAIT_SUPER_CRITICAL).reduce((r, trait) => r + trait.value, 0);
        const b = this.traits(Game_BattlerBase.TRAIT_FATAL_BLOW).reduce((r, trait) => r + trait.value, 0);
        return Math.min(a + b, 100);
    };

    // ダメージ上限突破の合計を取得
    Game_BattlerBase.prototype.traitsDamageCapBreak = function() {
        return this.traits(Game_BattlerBase.TRAIT_DAMAGE_CAP_BREAK).reduce((r, trait) => r + trait.value, 0);
    };

    // カウンターの合計を取得
    Game_BattlerBase.prototype.traitsCounter = function() {
        const value = this.traits(Game_BattlerBase.TRAIT_COUNTER).reduce((r, trait) => r + trait.value, 0);
        return Math.min(value, 100);
    };

    // HP再生を取得
    Game_BattlerBase.prototype.traitsHpRegen = function() {
        const value = this.traits(Game_BattlerBase.TRAIT_HP_REGEN).reduce((r, trait) => r + trait.value, 0);
        return Math.min(value, 10);
    };

    // 命中率の再定義（命中は敵味方ともに１００％）
    Object.defineProperty(Game_BattlerBase.prototype, "hit", {
        get: function() {
            return 100;
        },
        configurable: true
        }
    );

    // 回避率の再定義（回避は敵味方ともに０％）
    Object.defineProperty(Game_BattlerBase.prototype, "eva", {
        get: function() {
            return 0;
        },
        configurable: true
        }
    );

    // HPが高いときに効果を得られる特徴の計算処理
    Game_BattlerBase.prototype.calcHpHighRate = function(base) {
        // 効果値がない場合は０を返す
        if (base == 0){
            return 0;
        }
        // 効果値がある場合
        else
        {
            // HP割合から効果量を取得
            const rate = (this.hpRate() - 0.5) / 0.5;
            const effectiveRate = Math.max(0, Math.min(rate, 1));

            return base * effectiveRate;
        }
    };

    // HPが低いときに効果を得られる特徴の計算処理
    Game_BattlerBase.prototype.calcHpLowRate = function(base) {
        // 効果値がない場合は０を返す
        if (base == 0){
            return 0;
        }
        // 効果値がある場合
        else
        {
            // HP割合から効果量を取得
            const rate = (1.0 - this.hpRate()) / 8.5;
            const effectiveRate = Math.max(0, Math.min(rate, 1));

            return base * effectiveRate;
        }
    };

    // 背水の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "las", {
        get: function() {
            // ％で指定してるので、１００を足す
            return (this.calcHpLowRate(this.traitsLastStand()) + 100);
        },
        configurable: true
        }
    );

    // 旺盛の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "vig", {
        get: function() {
            // ％で指定してるので、１００を足す
            return (this.calcHpHighRate(this.traitsVigor()) + 100);
        },
        configurable: true
        }
    );

    // 不屈の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "uny", {
        get: function() {
            // 受けるダメージを減らす処理なので１００から効果値を引いて渡す
            return (100 - this.calcHpLowRate(this.traitsVigor()));
        },
        configurable: true
        }
    );

    // 盤石の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "for", {
        get: function() {
            // 受けるダメージを減らす処理なので１００から効果値を引いて渡す
            return (100 - this.calcHpHighRate(this.traitsFortitude()));
        },
        configurable: true
        }
    );

    // 超会心の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "scr", {
        get: function() {
            // 使うときは百分率になるから１００で割っとく
            return this.traitsSuperCritical() / 100;
        },
        configurable: true
        }
    );

    // ダメージ上限突破の取得処理
    Object.defineProperty(Game_BattlerBase.prototype, "dcb", {
        get: function() {
            // 使うときは百分率になるから１００を足しとく
            return this.traitsDamageCapBreak();
        },
        configurable: true
        }
    );

    // アクターの最大HP取得処理再定義
    Object.defineProperty(Game_Actor.prototype, "mhp", {
        get: function() {
            let value = 50;

            // 武器のHP
            for (const w of this.weapons()) {
                value += w.hp || 0;
            }

            // 攻撃力加算の特徴分追加
            value += this.traitsHpPlus();

            // // 攻撃力乗算の特徴分追加
            value = value * (this.traitsHpRate() + 100) / 100;
            return Math.floor(value);
        },
        configurable: true
        }
    );

    // アクターのATK取得処理再定義
    Object.defineProperty(Game_Actor.prototype, "atk", {
        get: function() {
            let value = 5;

            // 武器の攻撃力
            for (const w of this.weapons()) {
                value += w.atk || 0;
            }

            // 攻撃力加算の特徴分追加
            value += this.traitsAtkPlus();

            // 攻撃力乗算の特徴分追加
            value = value * (this.traitsAtkRate() + 100) / 100;
            return Math.floor(value);
        },
        configurable: true
        }
    );

    // アクターの会心率取得処理再定義
    Object.defineProperty(Game_Actor.prototype, "cri", {
        get: function() {
            // 使うときは百分率になるから１００で割っとく
            return this.traitsCriticalPlus() / 100;
        },
        configurable: true
        }
    );

    // アクターのカウンター率取得処理再定義
    Object.defineProperty(Game_Actor.prototype, "cnt", {
        get: function() {
            // 使うときは百分率になるから１００で割っとく
            return this.traitsCounter() / 100;
        },
        configurable: true
        }
    );

    // アクターのHP再生率取得処理再定義
    Object.defineProperty(Game_Actor.prototype, "hrg", {
        get: function() {
            // 使うときは百分率になるから１００で割っとく
            return this.traitsHpRegen() / 100;
        },
        configurable: true
        }
    );

    // ダメージ上限
    Game_BattlerBase.prototype.maxDamage = function() {
        // 主に敵側で制限をかけない用の数値に
        return 999999999999;
    };

    // 通常攻撃のヒット数の加算処理
    Game_Actor.prototype.attackTimesAdd = function() {
        const value = this.traitsHitCountPlus();
        const guaranteed = Math.floor(value / 100);
        const remainder = value % 100;
        const extra = Math.random() * 100 < remainder ? 1 : 0;
        return guaranteed + extra;
    };

    // 連続行動判定用の処理
    Game_Actor.prototype.actionPlusSet = function() {
        const value = this.traitsMultiAttack();
        const guaranteed = Math.floor(value / 100);
        const remainder = value % 100;

        // 結果保存用配列
        let array = [];

        // 連続行動成功率１００％の特徴の作成
        for(let i = 0; i < guaranteed; i++){
            array.push(1);
        }

        // 余った分の成功率で特徴を作成
        if (remainder > 0) {
            array.push(remainder / 100);
        }

        return array;
    };

    // 装備品スロット取得
    Game_Actor.prototype.equipSlots = function() {
        return Array(10).fill(1);
    };

    // ダメージ上限
    Game_Actor.prototype.maxDamage = function() {
        // アクター側はダメージ限界突破で上限を増やす
        return 9999 * (this.dcb + 100) / 100;
    };

    // 二刀流扱いにされるから攻撃モーションを固定
    Sprite_Actor.prototype.attackMotion = function() {
        this.startMotion("attack");
    };

    // エネミーのパラメータ取得処理
    Game_Enemy.prototype.paramBase = function(paramId) {
        return this.enemy().exparams[paramId];
    };

    // ドロップ取得処理
    Game_Enemy.prototype.makeDropItems = function() {
        const rate = this.dropItemRate();
        return this.makeDropItemsArray().reduce((r, di) => {
            if (di.kind > 0 && Math.random() * di.denominator < rate) {
                return r.concat(this.itemObject(di.kind, di.dataId));
            } else {
                return r;
            }
        }, []);
    };

    // ドロップアイテム配列の取得処理
    Game_Enemy.prototype.makeDropItemsArray = function() {
        const array = [];
        array.push(this.createDropItem(2, this.enemy().rank, 1));
        array.push(this.createDropItem(2, this.enemy().rank, 2));
        array.push(this.createDropItem(2, this.enemy().rank, 4));
        return array;
    };

    // ドロップアイテムの作成処理
    Game_Enemy.prototype.createDropItem = function(kind, dataId, denominator) {
        const item = {};
        item.kind = kind;
        item.dataId = dataId;
        item.denominator = denominator;
        return item;
    };

})();